<!DOCTYPE html>
<html>
<head>
<title>Meditate GPT</title>
<meta name="viewport" content="width=device-width, initial-scale=1"/>
<link rel="stylesheet" href="css/bootstrap.min.css">
<link rel="stylesheet" href="css/style.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
<style>
.toast-success {
  background-color: #fff;
}
.toast-progress{
  background-color: none;
}
#toast-container>div { 
	color: #000;
	box-shadow: 0 0 3px #999;
	padding: 15px 20px 20px 25px; 
}
.toast-close-button{
font-weight: normal;
color: grey;
}

label {
  display: block;
  margin-bottom: 5px;
}
input.error {
  border: 1px solid red;
}
.error {
  color: red;
  margin-top: 5px;
  float: left;
  width: 100%;
  font-size: 14px;
}
</style>
</head>
<body>

<div class="medi_main">    
    <div class="click_theme">
        <div class="theme_changer">
            <span class="btn_toggle">
                <svg width="15" height="15" viewBox="0 0 15 15" fill="none" xmlns="http://www.w3.org/2000/svg" class="h-[1.2rem] w-[1.2rem] rotate-0 scale-100 transition-all dark:-rotate-90 dark:scale-0">
                    <path d="M7.5 0C7.77614 0 8 0.223858 8 0.5V2.5C8 2.77614 7.77614 3 7.5 3C7.22386 3 7 2.77614 7 2.5V0.5C7 0.223858 7.22386 0 7.5 0ZM2.1967 2.1967C2.39196 2.00144 2.70854 2.00144 2.90381 2.1967L4.31802 3.61091C4.51328 3.80617 4.51328 4.12276 4.31802 4.31802C4.12276 4.51328 3.80617 4.51328 3.61091 4.31802L2.1967 2.90381C2.00144 2.70854 2.00144 2.39196 2.1967 2.1967ZM0.5 7C0.223858 7 0 7.22386 0 7.5C0 7.77614 0.223858 8 0.5 8H2.5C2.77614 8 3 7.77614 3 7.5C3 7.22386 2.77614 7 2.5 7H0.5ZM2.1967 12.8033C2.00144 12.608 2.00144 12.2915 2.1967 12.0962L3.61091 10.682C3.80617 10.4867 4.12276 10.4867 4.31802 10.682C4.51328 10.8772 4.51328 11.1938 4.31802 11.3891L2.90381 12.8033C2.70854 12.9986 2.39196 12.9986 2.1967 12.8033ZM12.5 7C12.2239 7 12 7.22386 12 7.5C12 7.77614 12.2239 8 12.5 8H14.5C14.7761 8 15 7.77614 15 7.5C15 7.22386 14.7761 7 14.5 7H12.5ZM10.682 4.31802C10.4867 4.12276 10.4867 3.80617 10.682 3.61091L12.0962 2.1967C12.2915 2.00144 12.608 2.00144 12.8033 2.1967C12.9986 2.39196 12.9986 2.70854 12.8033 2.90381L11.3891 4.31802C11.1938 4.51328 10.8772 4.51328 10.682 4.31802ZM8 12.5C8 12.2239 7.77614 12 7.5 12C7.22386 12 7 12.2239 7 12.5V14.5C7 14.7761 7.22386 15 7.5 15C7.77614 15 8 14.7761 8 14.5V12.5ZM10.682 10.682C10.8772 10.4867 11.1938 10.4867 11.3891 10.682L12.8033 12.0962C12.9986 12.2915 12.9986 12.608 12.8033 12.8033C12.608 12.9986 12.2915 12.9986 12.0962 12.8033L10.682 11.3891C10.4867 11.1938 10.4867 10.8772 10.682 10.682ZM5.5 7.5C5.5 6.39543 6.39543 5.5 7.5 5.5C8.60457 5.5 9.5 6.39543 9.5 7.5C9.5 8.60457 8.60457 9.5 7.5 9.5C6.39543 9.5 5.5 8.60457 5.5 7.5ZM7.5 4.5C5.84315 4.5 4.5 5.84315 4.5 7.5C4.5 9.15685 5.84315 10.5 7.5 10.5C9.15685 10.5 10.5 9.15685 10.5 7.5C10.5 5.84315 9.15685 4.5 7.5 4.5Z" fill="currentColor" fill-rule="evenodd" clip-rule="evenodd"></path>
                </svg>
            </span>
            <ul class="theme_option">
                <li>Light</li>
                <li>Dark</li>
                <li>System</li>
            </ul>
        </div>
    </div>

    <div class="generate_audio_main">
        <div class="generate_audio">
            <div class="logo_page">
                <h2>Meditate GPT 🧘🏻</h2>
                <p>Powered by BuildShip</p>
            </div>
 
            <form id="gptForm" action="javascript:void(0)">
                <div class="input_block">
                    <label>Description</label>
                    <textarea name="description" id="" placeholder="I'm feeling nostalgic, help me focus on the present and future"></textarea>
                    <p>Describe your meditation session</p>
                </div>
                <div class="radio_select input_block">
                    <label>Meditation duration</label>
                    <div class="radio_main">
                        <div class="radio_btn">
                            <input checked type="radio" id="audio_short" name="duration" value="300">
                            <span class="radio_icon"></span>
                            <label for="audio_short">5 minutes</label>
                        </div>
                        <div class="radio_btn">
                            <input type="radio" id="audio_long" name="duration" value="600">
                            <span class="radio_icon"></span>
                            <label for="audio_long">10 minutes</label>
                        </div>
                    </div>
                </div>
                <div class="input_block">
                    <label>Email</label>
                    <input type="email" name="email" placeholder="">
                    <p>Enter your email to receive the meditation audio via email once it's generated</p>
                </div>
                    <button type="submit" class="generate_btn">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="mr-2 h-4 w-4 animate-spin"><path d="M21 12a9 9 0 1 1-6.219-8.56"></path></svg>
                        <span>Generate<span>
                    </button>
            </form>

            <p>Generate a meditation session complete with a relaxing background, featuring gentle music, and guided breathing exercises to help you achieve a state of deep relaxation and mindfulness.</p>
        </div>
    </div>
    <div class="audio_foot">
        <audio controls="" src="audio/audio.mp3" class="w-full">Your browser does not support the audio element.</audio>
    </div>
</div> 
</body>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
  <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>

<script src="js/bootstrap.min.js"></script>
<script>
// Set the options that I want
toastr.options = {
  "closeButton": true,
  "newestOnTop": false,
  "progressBar": true,
  "positionClass": "toast-bottom-right",
  "preventDuplicates": false,
  "onclick": null,
  "showDuration": "300",
  "hideDuration": "1000",
  "timeOut": "5000",
  "extendedTimeOut": "1000",
  "showEasing": "swing",
  "hideEasing": "linear",
  "showMethod": "fadeIn",
  "hideMethod": "fadeOut"
}

</script>
</html>
 <script> 
	$(document).ready(function () {                 
		$('#gptForm').submit(function (event) { 
			if ($(this).valid()) {
				var form = document.getElementById('gptForm'); 
			var formData = new FormData(form); 
			$('.generate_btn').attr('disabled','disabled');
			$('.generate_btn span').text('Generating');
			$('.generate_btn').addClass('loading');
			$.ajax({ 
				url: 'gpt.php', 
				method: 'POST', 
				data: formData, 
				processData: false, 
				contentType: false, 
				success: function (response) {
					
					var obj = jQuery.parseJSON(response);
					$('.generate_btn').removeAttr('disabled','disabled');
					$('.generate_btn span').text('Generate');
					$('.generate_btn').removeClass('loading');
         // window.open(obj.link);
					toastr.success(obj.message);
          $('.audio_foot audio').attr('src',obj.link);
					//download_audio(obj.link);
				}, 
				error: function (xhr, status, error) {    
					toastr.success(error);                
					console.error(error); 
				} 
			}); 
        } else {
          event.preventDefault();
        }                
			
		}); 
	}); 
	
function download_audio(audiolink)
 {
      console.log("startdownload");
        jQuery.ajax({
          url: audiolink,
		  crossDomain: true,
          xhrFields:{
              responseType: 'blob'
          },
          success: function(data){            
            console.log("success");
              var blobData = data;
              var url = window.URL || window.webkitURL;
              var src = url.createObjectURL(data);
				var a = document.createElement('a');
				a.setAttribute('href', src);
				a.setAttribute('download', 'meditation.mp3');
				var aj = $(a);
				aj.appendTo('body');
				aj[0].click();
				aj.remove();       
          }
      });
}
</script>
<script>
	$(document).ready(function () {
      // Add validation rules to the form
      $("#gptForm").validate({
        rules: {
          description: {
            required: true,
			minlength: 6
          },
          email: {
			required: true,
            email: true
          }
        },
		 messages: {
          description: {
            required: "Description must be at least 6 characters.",
			minlength: "Description must be at least 6 characters.",
          }
		},
        errorElement: "div", // Display error messages in a <div> element
        errorPlacement: function(error, element) {
          // Position the error messages after the input fields
          error.insertAfter(element);
        }
      });
    });
  </script>

