<!DOCTYPE html>
<html lang="en">
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Distance Calculator with Map</title>
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/css/bootstrap.min.css" integrity="sha512-rt/SrQ4UNIaGfDyEXZtNcyWvQeOq0QLygHluFQcSjaGB04IxWhal71tKuzP6K8eYXYB6vJV4pHkXcmFGGQ1/0w==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.12.1/themes/base/jquery-ui.css">

	<link rel="stylesheet" type="text/css" href="css/style.css">
	<style>
		@import url('https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap');
	</style>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyDhnWdx9c6lQTV9j8WtLr-dEtEVENT7k0Q&libraries=places"></script>
    
</head>
<body>
<header>
		<div class="container">
			<div class="header_inner">
				<a href="javascript:void(0)">
					<svg viewBox="0 0 48 48" xmlns="http://www.w3.org/2000/svg" >
						<svg viewBox="-4.8 -4.8 57.60 57.60" xmlns="http://www.w3.org/2000/svg" fill="#faa918" stroke="#faa918"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M0 0h48v48H0z" fill="none"></path> <g id="Shopicon"> <polygon points="44,30 40,30 40,38 8,38 8,10 20,10 20,6 4,6 4,42 44,42 "></polygon> <polygon points="26,26.828 40,12.828 40,24 44,24 44,6 26,6 26,10 37.172,10 23.172,24 "></polygon> </g> </g></svg>
					</svg>
					New Reservation
				</a>
				<a href="javascript:void(0)">
					<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path opacity="0.5" d="M9.00195 7C9.01406 4.82497 9.11051 3.64706 9.87889 2.87868C10.7576 2 12.1718 2 15.0002 2L16.0002 2C18.8286 2 20.2429 2 21.1215 2.87868C22.0002 3.75736 22.0002 5.17157 22.0002 8L22.0002 16C22.0002 18.8284 22.0002 20.2426 21.1215 21.1213C20.2429 22 18.8286 22 16.0002 22H15.0002C12.1718 22 10.7576 22 9.87889 21.1213C9.11051 20.3529 9.01406 19.175 9.00195 17" stroke="#faa918" stroke-width="1.5" stroke-linecap="round"></path> <path d="M15 12L2 12M2 12L5.5 9M2 12L5.5 15" stroke="#faa918" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
					Log in
				</a>
			</div>
		</div>
	</header>
	<section class="steps_to_book">
		<div class="container">
			<div class="booking_step book_step_one">
                <!-- Loader element -->
                <!-- Loader element -->
                <div class="loader" style="display:none">
					<svg class="circular-loader" viewBox="25 25 50 50">
						<circle class="loader-path" cx="50" cy="50" r="20" fill="none" stroke-width="3"></circle>
					</svg>
				</div>
                <form id="pick-drop-form">
				<button class="accordion active">
					Step 1: Ride Info
				</button>
				<div class="panel step-1" style="display: block;">
				  <div class="row main-row">
					<div class="col-md-6">
						<div class="booking_form">
							    <div class="input_field">
									<label>Vehicle Type</label>
                                    <select id="vehicle-type" name="vehicletype">
                                    <?php 
                                    $result = vehicleType();
                                    if(!empty($result))
                                    {
                                        while($row = $result->fetch_assoc()) {
                                            echo "<option value='".$row["id"]."'>".$row["name"]."</option>";
                                        }
                                    }
                                    ?>
									
									</select>
								</div>
								<div class="input_field">
									<label>Select Service Type</label>
                                    <select id="service-type" name="servicetype">
                                    <?php 
                                    $result = serviceType();
                                    if(!empty($result))
                                    {
                                        while($row = $result->fetch_assoc()) {
                                            echo "<option data-id='".$row["id"]."' value='".$row["service_key"]."'>".$row["service_name"]."</option>";
                                        }
                                    }
                                    ?>
									</select>
								</div>
								
								<div class="input_field width_half">
									<label>Pick-Up Date</label>
									<div class="input_calendar">
										<input id="pickup-date" type="calendar" name="pickup-date">
									</div>
								</div>
								
								<div class="input_field width_half">
									<label>Pick-Up Time</label>
									<div class="input-group date" id="timePicker">
                                    <input type="text" id="timepicker-input" class="form-control timepicker-input" name="timepicker-input" value="" size="10" autocomplete="off" />
                                    </div>
								</div>
    
								<div class="input_field">
									<label class="pickup">Pick-Up Airport</label>
                                    <div id="suggestion-list"></div>
									<div class="input-container">
										<input type="text" class="location-input origin-location" name="origin" id="origin" placeholder="Click to use current location or enter origin">
										<div class="current-location-label" id="originRadio">
											<label>
												<input type="radio" name="originOption" value="currentLocation">
												Use Current Location
											</label>
										</div>
									</div>
								</div>
								<div class="input_field add_stop">
									<button type="button" onclick="addStop()" class="add_stop_btn">
										<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M4 12H20M12 4V20" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
										Add Stop
									</button>
									<div id="stops-container"></div>
                                    
								</div>
								
								<div class="input_field parent-drop-off">
									<label class="drop-off">Drop-Off Location</label>
									<div class="input-container">
										<input type="text" class="location-input destination-location" name="destination" id="destination" placeholder="Click to use current location or enter destination">
										<div class="current-location-label" id="destinationRadio">
											<label>
												<input type="radio" name="destinationOption" value="currentLocation">
												Use Current Location
											</label>
										</div>
									</div>
								</div>
								
								<div class="passengers_luggage">
									<div class="count_check passengers_count">
										<label>Number of Passengers</label>
										<div class="counter">
											<span class="decrease_count" onclick="decreaseCount('passenger_count')">
												<svg width="15px" height="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M6 12L18 12" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
											</span>
												<input readonly type="text" class="number_count" name="passengerqty" id="passenger_count" value="1">
											<span class="increase_count" onclick="increaseCount('passenger_count')">
												<svg width="15px" height="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M4 12H20M12 4V20" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
											</span>
										</div>
									</div>
									
									<div class="count_check luggage_count">
										<label>Luggage Count</label>
										<div class="counter">
											<span class="decrease_count" onclick="decreaseCount('luggage_count')">
												<svg width="15px" height="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M6 12L18 12" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
											</span>
												<input readonly type="text" class="number_count" name="luggageqty" id="luggage_count" value="1" />
											<span class="increase_count" onclick="increaseCount('luggage_count')">
												<svg width="15px" height="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M4 12H20M12 4V20" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
											</span>
										</div>
									</div>
								</div>
								
								<div class="input_field add_stop">
									<button type="button" id="addChildSeatBtn" class="add_stop_btn">
										<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M4 12H20M12 4V20" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
										Add Child Seat
									</button>
                                    <div id="childSeatContainer">
                                        <!-- Child seat section will be appended here -->
                                    </div>
									<div class="child_seat_count" id="childSeatTemplate" style="display: none;">
                                        <div class="child_seat_inner">
                                            <select name="childseat[]">
                                            <option value="Infant (ages 0-1)">Infant (ages 0-1)</option>
                                            <option value="Toddler Seat (ages 1-3)">Toddler Seat (ages 1-3)</option>
                                            <option value="Booster Seat (ages 3-6)">Booster Seat (ages 3-6)</option>
                                            </select>
                                            <div class="counter">
                                            <span class="decrease_count">
                                                <svg class="decreaseIcon" width="15px" height="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M6 12L18 12" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
                                            </span>
                                            <input readonly type="text" class="number_count" name="childqty[]" value="1">
                                            <span class="increase_count">
                                                <svg class="increaseIcon" width="15px" height="15px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M4 12H20M12 4V20" stroke="#000000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
                                            </span>
                                            </div>
                                            <span class="delete_item">
                                            <svg class="deleteIcon" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M10 12V17" stroke="#ff0000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M14 12V17" stroke="#ff0000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M4 7H20" stroke="#ff0000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M6 10V18C6 19.6569 7.34315 21 9 21H15C16.6569 21 18 19.6569 18 18V10" stroke="#ff0000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M9 5C9 3.89543 9.89543 3 11 3H13C14.1046 3 15 3.89543 15 5V7H9V5Z" stroke="#ff0000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>
                                            </span>
                                        </div>
                                        </div>
								</div>
								
								<div class="input_field assesible_main">
									<label>Accessible</label>
									<div class="input-container">
										<label class="switch">
										  <input type="checkbox" name="accessible">
										  <span class="slider round"></span>
										</label>
										<div class="tooltip_cstm">
											<svg width="20px" height="20px" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path fill-rule="evenodd" clip-rule="evenodd" d="M22 12C22 17.5228 17.5228 22 12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12ZM12 17.75C12.4142 17.75 12.75 17.4142 12.75 17V11C12.75 10.5858 12.4142 10.25 12 10.25C11.5858 10.25 11.25 10.5858 11.25 11V17C11.25 17.4142 11.5858 17.75 12 17.75ZM12 7C12.5523 7 13 7.44772 13 8C13 8.55228 12.5523 9 12 9C11.4477 9 11 8.55228 11 8C11 7.44772 11.4477 7 12 7Z" fill="#000000"></path> </g></svg>
											<div class="tooltip_box">
												<p>
													We collect this data to ensure our vehicles/staff meet your individual needs.
												</p>
											</div>
										</div>
									</div>
								</div>
								
								<div class="input_field">
									<div class="btn-container">
										<!-- <button id="select-vehicle-button type="button" onclick="calculateDistance(elem1=false,elem2=false)"> -->
										<button id="select-vehicle-button" type="button">	
                                        Select Vehicle
										</button>
									</div>
									<p id="distance"></p>
								</div>
								
							
						</div>
					</div>
					<div class="col-md-6">
						<div id="map"></div>
					</div>
				  </div>

				  <div class="step_complete_view step1-comp-view" style="display: none;">
					<div class="row">
						<div class="col-md-6">
							<div class="time_selected">
								<h3>02/23/2024 1:55 AM</h3>
							</div>
							<div class="passenger_selected">
								<h4>Passenger: <span>1</span></h4>
							</div>
						</div>
						<div class="col-md-6">
							<div class="location_selected">
								<h3>From: <span>SAN - San Diego International Airport</span></h3>
								
								<h3>To: <span>SJT - San Angelo Regional Airport/Mathis Field</span></h3>
							</div>
						</div>
					</div>
				  </div>
				</div>
                </form>
			</div>
			
			
			<div class="booking_step book_step_two">
				<button class="accordion">
					Step 2: Select Vehicle
					<span class="click_filter">
						Sort By: Price : Low - High
						<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M12.75 20C12.75 20.4142 12.4142 20.75 12 20.75C11.5858 20.75 11.25 20.4142 11.25 20L11.25 10.75H6.00002C5.69668 10.75 5.4232 10.5673 5.30711 10.287C5.19103 10.0068 5.25519 9.68417 5.46969 9.46967L11.4697 3.46967C11.6103 3.32902 11.8011 3.25 12 3.25C12.1989 3.25 12.3897 3.32902 12.5304 3.46967L18.5304 9.46967C18.7449 9.68417 18.809 10.0068 18.6929 10.287C18.5768 10.5673 18.3034 10.75 18 10.75H12.75L12.75 20Z" fill="#000000"></path> </g></svg>
					</span>					
				</button>
				<div class="panel step-2">
				  <div class="select_car">
					<div class="row">
						<div class="col-md-3">
							<div class="select_car_inner">
								<img src="images/car.png" alt="">
								<div class="car_detail">
									<h2>Cadillac Escalade</h2>
									<div class="car_specification">
										<div class="space_avail">
											<svg fill="#000000" version="1.1" id="Capa_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 468.613 468.614" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <g> <path d="M187.947,116.517h-3.498c10.625-12.361,17.099-28.379,17.099-45.916C201.548,31.667,169.869,0,130.952,0 C92.023,0,60.363,31.667,60.363,70.601c0,17.537,6.47,33.555,17.102,45.916h-3.506c-19.651,0-35.627,16-35.627,35.645v117.105 c0,19.647,15.982,35.633,35.627,35.633h1.384v128.07c0,20.332,10.683,35.644,24.872,35.644h61.477 c14.192,0,24.905-15.312,24.905-35.644V304.893h1.363c19.642,0,35.635-15.99,35.635-35.632v-117.1 C223.585,132.511,207.595,116.517,187.947,116.517z"></path> <path d="M394.649,116.517h-3.507c10.635-12.361,17.102-28.379,17.102-45.916C408.244,31.667,376.581,0,337.646,0 c-38.911,0-70.593,31.667-70.593,70.601c0,17.537,6.479,33.555,17.102,45.916h-3.488c-19.654,0-35.627,16-35.627,35.645v117.105 c0,19.647,15.985,35.633,35.627,35.633h1.363v128.07c0,20.332,10.7,35.644,24.884,35.644h61.477 c14.195,0,24.896-15.312,24.896-35.644V304.893h1.369c19.635,0,35.626-15.99,35.626-35.632v-117.1 C430.276,132.511,414.291,116.517,394.649,116.517z"></path> </g> </g> </g></svg>
											<span>3</span>
										</div>
										<div class="space_avail">
											<svg fill="#000000" height="200px" width="200px" version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 128 128" xml:space="preserve"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <g> <path d="M79.9,23.4c0-4-3.5-6.5-7.8-6.5c0,0-16.4,0-16.3,0c-4.2,0-7.8,2.5-7.8,6.5v11H32.7v76.5h62.6V34.4H79.9V23.4z M74.2,34.4 H53.7V23.1h20.5V34.4z"></path> <path d="M7.2,45.8c0,0.2,0,53.3,0,53.3c0,7.4,5.6,11.7,11.4,11.7H27V34.2h-8.4C12.7,34.2,7.2,39.2,7.2,45.8z"></path> <path d="M109.4,34.2H101v76.6h8.4c5.8,0,11.4-4.3,11.4-11.7c0,0,0-53.1,0-53.3C120.8,39.2,115.3,34.2,109.4,34.2z"></path> </g> </g></svg>
											<span>3</span>
										</div>
									</div>
									<div class="ride_price">
										$6004.54
									</div>
									<a href="javascript:void(0)" class="book_now">
										Book Now
									</a>
								</div>
							</div>
						</div>
					</div>
				  </div>
				</div>
			</div>
		</div>
	</section>
    <div id="map-container">
        <div id="form-container"></div>
    </div>
   

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script><script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/4.6.2/js/bootstrap.bundle.min.js" integrity="sha512-igl8WEUuas9k5dtnhKqyyld6TzzRjvMqLC79jkgT3z02FvJyHAuUtyemm/P/jYSne1xwFI06ezQxEwweaiV7VA==" crossorigin="anonymous" referrerpolicy="no-referrer" defer="defer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dayjs/1.11.10/dayjs.min.js" integrity="sha512-FwNWaxyfy2XlEINoSnZh1JQ5TRRtGow0D6XcmAWmYCRgvqOUTnzCxPc9uF35u5ZEpirk1uhlPVA19tflhvnW1g==" crossorigin="anonymous" referrerpolicy="no-referrer" defer="defer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dayjs/1.11.10/plugin/customParseFormat.min.js" integrity="sha512-FM59hRKwY7JfAluyciYEi3QahhG/wPBo6Yjv6SaPsh061nFDVSukJlpN+4Ow5zgNyuDKkP3deru35PHOEncwsw==" crossorigin="anonymous" referrerpolicy="no-referrer" defer="defer"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/js/all.min.js" integrity="sha512-Tn2m0TIpgVyTzzvmxLNuqbSJH3JP8jm+Cy3hvHrW7ndTDcJ1w5mBiksqDBb8GpE2ksktFvDB/ykZ0mDpsZj20w==" crossorigin="anonymous" referrerpolicy="no-referrer" defer="defer"></script>
    <script src="https://cdn.jsdelivr.net/jquery.validation/1.16.0/jquery.validate.min.js"></script>
    <script src="js/timepicker-bs4.js?" defer="defer"></script>
    <script src="js/map.js"></script>
    <script src="js/timepicker.js"></script>
    <script>
    $(document).ready(function() {
    $('#select-vehicle-button').click(function() {
        
       if ($('#pick-drop-form').valid()) {

            calculateDistance(function(distanceData) {

            var serviceTypeId = $('#service-type option:selected').data('id');
            // Serialize form data
            var formData = $('#pick-drop-form :input').not(':hidden').serialize();
            formData += '&serviceTypeId=' + serviceTypeId;
            formData += '&action=calculatePointToPointPrice';

            // Include distance data in the formData
            formData += '&totalDistance=' + distanceData.totalDistanceInKm;
            formData += '&totalDuration=' + distanceData.totalDurationInHours;
            $('.loader').show();
            // AJAX request
            $.ajax({
                type: 'POST',
                url: 'calculations', // PHP script for processing
                data: formData,
                success: function(response) {
                    // Handle the response from the PHP script
                    console.log(response);

                    var datepicker = $('#pickup-date').val(); // Get the selected date
                    var timepicker = $('#timepicker-input').val(); // Get the selected date
                    var passengerCount = $('#passenger_count').val(); // Get the selected passenger count
                    var originLocation = $('.origin-location').val(); // Get the selected origin location
                    var destinationLocation = $('.destination-location').val(); // Get the selected destination location
                        
                    $('.step1-comp-view .time_selected h3').text(datepicker+' '+timepicker);
                    $('.step1-comp-view .passenger_selected span').text(passengerCount);
                    $('.step1-comp-view .location_selected h3:first-child span').text(originLocation);
                    $('.step1-comp-view .location_selected h3:last-child span').text(destinationLocation);
                        
                    $('.ride_price').text(response);

                    // You can update UI or take action based on the response
                    $('.step1-comp-view').show();
                    $('.loader').hide();
                    $('.step-1 .main-row').hide();
                    $('.step-2').show();
                },
                error: function(xhr, status, error) {
                    // Handle errorsFVF
                    console.error(xhr.responseText);
                }
            });
        });
    }
    });
});
</script>
</body>
</html>