var map;
var directionsService;
var directionsRenderer;
var stops = [];
var location_init = '';
var check = 'from-airport';
$(document).ready(function(){

    // Initialize autocomplete for origin and destination
    var originInput = document.getElementById('origin');
    var destinationInput = document.getElementById('destination');
    var autocompleteOrigin = new google.maps.places.Autocomplete(originInput);
    var autocompleteDestination = new google.maps.places.Autocomplete(destinationInput);
    configureAutocomplete(autocompleteOrigin, ['airport']);
    configureAutocomplete(autocompleteDestination, []);
    
    // Event handler for service type change
    $(document).on('change','#service-type',function(){
        var servicetype = $(this).val();

        // Adjust autocomplete based on service type
        if (servicetype === 'from-airport') {
            $('.pickup').text('Pick-Up Airport');
            $('.drop-off').text('Drop-Off Location');
            $('.parent-drop-off').show();
            // Configure autocomplete for 'From Airport'
            configureAutocomplete(autocompleteOrigin, ['airport']);
            configureAutocomplete(autocompleteDestination, []);
        } else if (servicetype === 'to-airport') {
            $('.pickup').text('Pick-Up Location');
            $('.drop-off').text('Drop-Off Airport');
            $('.parent-drop-off').show();
            // Configure autocomplete for 'To Airport'
            configureAutocomplete(autocompleteOrigin, []);
            configureAutocomplete(autocompleteDestination, ['airport']);
        }
        else if (servicetype === 'point-to-point') {
            $('.pickup').text('Pick-Up Location');
            $('.drop-off').text('Drop-Off Location');
            $('.parent-drop-off').show();
            configureAutocomplete(autocompleteOrigin, []);
            configureAutocomplete(autocompleteDestination, []);
        }
        else {
            $('.pickup').text('Pick-Up Location');
            $('.drop-off').text('Drop-Off Location');
            $('.parent-drop-off').hide();
            // Default configuration for other service types
            configureAutocomplete(autocompleteOrigin, []);
            configureAutocomplete(autocompleteDestination, []);
        }
    });

    // Function to configure autocomplete with specified types
    function configureAutocomplete(autocomplete, types) {
        autocomplete.setTypes(types);
    }

});







initializeMap();

function initializeMap() {
    map = new google.maps.Map(document.getElementById('map'), {
        center: { lat: 0, lng: 0 },
        zoom: 3
    });
    directionsService = new google.maps.DirectionsService();
    directionsRenderer = new google.maps.DirectionsRenderer({
        map: map
    });
}


function addStop() {
    // Create a container div for the input field and the delete icon
    var stopContainer = document.createElement('div');
    stopContainer.classList.add('stop-container');

    // Create the input field for the stop
    var stopInput = document.createElement('input');
    stopInput.setAttribute('type', 'text');
    stopInput.setAttribute('name', 'stoppoints[]');
    stopInput.className = 'stop-input';
    stopInput.setAttribute('placeholder', 'Enter stop location');
    stops.push(stopInput);
    
    // Create the delete icon
    var deleteIcon = document.createElement('span');
    deleteIcon.classList.add('delete_item');
    deleteIcon.innerHTML = '<svg viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><g id="SVGRepo_bgCarrier" stroke-width="0"></g><g id="SVGRepo_tracerCarrier" stroke-linecap="round" stroke-linejoin="round"></g><g id="SVGRepo_iconCarrier"> <path d="M10 12V17" stroke="#ff0000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M14 12V17" stroke="#ff0000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M4 7H20" stroke="#ff0000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M6 10V18C6 19.6569 7.34315 21 9 21H15C16.6569 21 18 19.6569 18 18V10" stroke="#ff0000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> <path d="M9 5C9 3.89543 9.89543 3 11 3H13C14.1046 3 15 3.89543 15 5V7H9V5Z" stroke="#ff0000" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path> </g></svg>';

    // Append the input field and the delete icon to the container
    stopContainer.appendChild(stopInput);
    stopContainer.appendChild(deleteIcon);

    // Get the container for stops and append the new stop container
    var stopsContainer = document.getElementById('stops-container');
    stopsContainer.appendChild(stopContainer);

    // Add event listener to the delete icon to remove the stop when clicked
    deleteIcon.addEventListener('click', function() {
        // Remove the stop container from the DOM
        stopContainer.remove();

        // Remove the corresponding stop from the stops array
        var index = stops.indexOf(stopInput);
        if (index > -1) {
            stops.splice(index, 1);
        }

        // Recalculate the route after stop is removed
        calculateDistance();
    });

    // Initialize autocomplete for the new stop input field
    initializeAutocomplete(stopInput);
}



//AirpotDetails();

function AirpotDetails(pickupname) {
    const airportName = pickupname.trim().toLowerCase();
    const apiUrl = `http://127.0.0.1/map/airports.csv`;

    fetch(apiUrl)
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.text();
        })
        .then(data => {
            const rows = data.split('\n').slice(1); // Skip header row
            const matchingAirports = rows.filter(row => {
                const rowData = row.split(',');
                const airportNameFromCSV = rowData[4];
                return airportNameFromCSV && airportNameFromCSV.trim().toLowerCase().startsWith(airportName);
            });

            $("#suggestion-list").html('');
            if (matchingAirports.length > 0) {
                matchingAirports.slice(0, 5).forEach(airport => {
                    const airportData = airport.split(',');
                    const airportName = airportData[4].trim();
                    const airportCode = airportData[2].trim();
                    $("#suggestion-list").append(`<div>${airportCode} - ${airportName}</div>`);
                    console.log(`Airport Code: ${airportCode}, Airport Name: ${airportName}`);
                });
            } else {
                console.log(`No airports found starting with '${airportName}'.`);
            }
        })
        .catch(error => console.error('Error fetching or processing airport data:', error));
}




function calculateDistance(callback) {

var origin = document.getElementById('origin').value;
var destination = document.getElementById('destination').value;


var waypoints = [];

stops.forEach(function(stop) {
    if (stop.value.trim() !== '') {
        waypoints.push({
            location: stop.value,
            stopover: true
        });
    }
});

var request = {
    origin: origin,
    destination: destination,
    waypoints: waypoints,
    travelMode: google.maps.TravelMode.DRIVING
};

directionsService.route(request, function(response, status) {
    if (status == 'OK') {
        directionsRenderer.setDirections(response);
        var totalDistance = 0;
        var totalDurationInSeconds = 0;
        response.routes[0].legs.forEach(function(leg) {
            totalDistance += leg.distance.value;
            totalDurationInSeconds += leg.duration.value;
        });
        var totalDistanceInKm = totalDistance / 1000; // Convert to kilometers
        var totalDurationInHours = totalDurationInSeconds / 3600; // Convert seconds to hours
        callback({
            totalDistanceInKm: totalDistanceInKm.toFixed(2),
            totalDurationInHours: totalDurationInHours.toFixed(2)
        });
    } else {
        window.alert('Directions request failed due to ' + status);
    }
});
}




function toggleCurrentLocationRadio(inputId) {
    var radio = document.getElementById(inputId + 'Radio');
    var inputField = document.getElementById(inputId);
    radio.style.display = 'block';

    var radioBtn = radio.querySelector('input[type="radio"]');
    radioBtn.addEventListener('change', function() {
        if (this.checked) {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                    var geocoder = new google.maps.Geocoder();
                    var latLng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);

                    geocoder.geocode({ 'location': latLng }, function(results, status) {
                        if (status === 'OK') {
                            if (results[0]) {
                                inputField.value = results[0].formatted_address;
                                radio.style.display = 'none';
                            } else {
                                console.log('No results found');
                            }
                        } else {
                            console.log('Geocoder failed due to: ' + status);
                        }
                    });
                }, function() {
                    console.log('Geolocation service failed');
                });
            } else {
                console.log('Browser does not support Geolocation');
            }
        }
    });

    inputField.addEventListener('blur', function() {
        setTimeout(function() {
            radio.style.display = 'none';
        }, 200);
    });
}


var originInput = document.getElementById('origin');
originInput.addEventListener('focus', function() {
    toggleCurrentLocationRadio('origin');
});


var destinationInput = document.getElementById('destination');
destinationInput.addEventListener('focus', function() {
    toggleCurrentLocationRadio('destination');
});


function initializeAutocomplete(input) {
    var autocomplete = new google.maps.places.Autocomplete(input);
    return autocomplete;
    
}

// // Autocomplete for stops
var stopInputs = document.querySelectorAll('.stop-input');
stopInputs.forEach(function(stopInput) {
    initializeAutocomplete(stopInput);
});

// var acc = document.getElementsByClassName("accordion");
// var i;

// for (i = 0; i < acc.length; i++) {
//   acc[i].addEventListener("click", function() {
//     this.classList.toggle("active");
//     var panel = this.nextElementSibling;
//     if (panel.style.display === "block") {
//       panel.style.display = "none";
//     } else {
//       panel.style.display = "block";
//     }
//   });
// }

// Function to decrease the count
function decreaseCount(elementId) {
    var countElement = document.getElementById(elementId);
    var count = parseInt(countElement.value);
    if (count > 1) {
        count--;
        countElement.value = count;
    }
}

// Function to increase the count
function increaseCount(elementId) {
    var countElement = document.getElementById(elementId);
    var count = parseInt(countElement.value);
    count++;
    countElement.value = count;
}



$("#pickup-date").datepicker({
    dateFormat: "dd-mm-yy", // Set the date format as per your requirement
    minDate: 0, // Disable past dates
    beforeShowDay: function(date) {
        var today = new Date();
        // Enable all dates including the current date
        var enable = [true, ''];
        // Check if the date is today
        if (date.getDate() === today.getDate() && date.getMonth() === today.getMonth() && date.getFullYear() === today.getFullYear()) {
            // Set custom CSS class for today
            enable[1] = 'ui-datepicker-today-custom';
        }
        return enable;
    }
});



$(document).ready(function() {
  $("#addChildSeatBtn").on("click", function() {
    addChildSeat();
  });

  $("#childSeatContainer").on("click", ".delete_item", function() {
    $(this).closest(".child_seat_count").remove();
  });

  function addChildSeat() {
    var $childSeatTemplate = $("#childSeatTemplate").clone();
    $childSeatTemplate.removeAttr("id").css("display", "block");
    $("#childSeatContainer").append($childSeatTemplate);
  }

  $("#childSeatContainer").on("click", ".decrease_count", function() {
    var $count = $(this).siblings(".number_count");
    var countVal = parseInt($count.val());
    if (countVal > 1) {
      $count.val(countVal - 1);
    }
  });

  $("#childSeatContainer").on("click", ".increase_count", function() {
    var $count = $(this).siblings(".number_count");
    var countVal = parseInt($count.val());
    $count.val(countVal + 1);
  });
});

$(document).ready(function() {
    $('#select-vehicle-button').click(function(event) {
    $('#pick-drop-form').validate({
        rules: {
          'pickup-date': {
            required: true
          },
          'timepicker-input': {
            required: true
          },
          origin: {
            required: true
          },
          destination: {
            required: true
          }
        },
        messages: {
          'pickup-date': {
            required: "Please select a pick-up date"
          },
          'timepicker-input': {
            required: "Please select a pick-up time"
          },
          origin: {
            required: "Please enter the pick-up airport"
          },
          destination: {
            required: "Please enter the drop-off location"
          }
        },
        submitHandler: function(form) {
          // You can add custom logic here if the form is valid
          form.submit();
        }
      }).form(); // <- This line triggers the validation
    });
  });
