<?php
// Check if the user is already logged in, if yes, redirect them to the dashboard
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] === false){
  header("Location: " . BASE_ADMIN_URL); // Assuming login.php is your login page
    exit;
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>
    Dashboard
  </title>
  <?php echo require_once 'header.php' ?>
</head>

<body class="">
  <nav class="navbar navbar-vertical fixed-left navbar-expand-md navbar-light bg-white" id="sidenav-main">
    <div class="container-fluid">
      <!-- Brand -->
      <a class="navbar-brand pt-0" href="../index.html">
        <img src="#" class="navbar-brand-img" alt="Logo">
      </a>
     
      <!-- Collapse -->
      <div class="collapse navbar-collapse" id="sidenav-collapse-main">
        <!-- Navigation -->
        <?php require_once 'sidebar.php'; ?>
      </div>
    </div>
  </nav>
  <div class="main-content">
    <!-- Navbar -->
    <nav class="navbar navbar-top navbar-expand-md navbar-dark" id="navbar-main">
      <div class="container-fluid">
       
        <!-- User -->
        <ul class="navbar-nav align-items-center d-none d-md-flex">
          <li class="nav-item dropdown">
            <a class="nav-link pr-0" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              <div class="media align-items-center">
                <span class="avatar avatar-sm rounded-circle">
                  <img alt="Image placeholder" src="assets/img/theme/team-4-800x800.jpg">
                </span>
                <div class="media-body ml-2 d-none d-lg-block">
                  <span class="mb-0 text-sm  font-weight-bold">Admin</span>
                </div>
              </div>
            </a>
            <div class="dropdown-menu dropdown-menu-arrow dropdown-menu-right">
              <div class=" dropdown-header noti-title">
                <h6 class="text-overflow m-0">Welcome!</h6>
              </div>
              
              <div class="dropdown-divider"></div>
              <a href="<?php echo BASE_ADMIN_URL; ?>logout" class="dropdown-item">
                <i class="ni ni-user-run"></i>
                <span>Logout</span>
              </a>
            </div>
          </li>
        </ul>
      </div>
    </nav>
    <!-- End Navbar -->
    <!-- Header -->
    <div class="header bg-gradient-primary pb-8 pt-5 pt-md-8">
      <div class="container-fluid">
        <div class="row">
            <div class="mb-0">
                <h1>Add Vehicle Pricing</h1>
            </div>
        </div>
      </div>
    </div>
      <div class="container-fluid mt--7">
        <!-- Table -->
        <div class="row">
            <div class="col">
              <form action="functions" method="post">
                <div class="col-md-12">
                  <label>Vehicle Type</label>
                  <select name="vehicletype">
                      <?php 
                        $result = getVehicles($id=null);     
                        if ($result->num_rows > 0) {
                          while ($row = $result->fetch_assoc()) {
                            echo "<option value=".$row["id"].">".$row["name"]."</option>";
                          }
                        }
                      ?>							
                  </select>
                </div>
                <div class="col-md-12">
                  <label>Day of Week</label>
                  <select name="dayWeek[]" multiple>
                      <option value="Sunday">Sunday</option>
                      <option value="Monday">Monday</option>
                      <option value="Tuesday">Tuesday</option>
                      <option value="Wednesday">Wednesday</option>
                      <option value="Thursday">Thursday</option>
                      <option value="Friday">Friday</option>
                      <option value="Saturday">Saturday</option>
                  </select>
                </div>
                <div class="col-md-12">
                  <label>Minimum Hours With In City</label>
                  <input type="text" name="minHoursInCity">
                </div>
                <div class="col-md-12">
                  <label>Minimum Hours City To City</label>
                  <input type="text" name="minHoursCityToCity">
                </div>
                <div class="col-md-12">
                  <label>Hourly Rate</label>
                  <input type="text" name="hourlyRate">
                </div>
                <div class="col-md-12">
                  <label>Per Mile Rate</label>
                  <input type="text" name="perMileRate">
                </div>
                <div class="col-md-12">
                  <label>Minimum Charge</label>
                  <input type="text" name="minCharge">
                </div>
                <div class="col-md-12">
                  <input type="submit" name="addPricing" value="Submit">
                </div>
              </form>
            </div>
        </div>
      </div>
      
   
    </div>
  </div>
  <!--   Core   -->
  <?php echo require_once 'footer.php' ?>
  
</body>

</html>

<script>
$(document).ready(function() {
    $('form').validate({
        rules: {
            vehicletype: 'required',
            'dayWeek[]': 'required',
            minHoursInCity: {
                required: true,
                number: true
            },
            minHoursCityToCity: {
                required: true,
                number: true
            },
            hourlyRate: {
                required: true,
                number: true
            },
            perMileRate: {
                required: true,
                number: true
            },
            minCharge: {
                required: true,
                number: true
            }
        },
        submitHandler: function(form) {
            form.submit(); // Submit the form if validation passes
        }
    });
});
</script>
