<?php
// Check if the user is already logged in, if yes, redirect them to the dashboard
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] === false){
  header("Location: " . BASE_ADMIN_URL);
  exit;
}
// Check if the user is already logged in, if yes, redirect them to the dashboard
$messages = '';
if(isset($_SESSION["message"])){
  $messages = $_SESSION['message'];
}

?>
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>
    Dashboard
  </title>
  <?php echo require_once 'header.php' ?>
</head>

<body class="">
  <nav class="navbar navbar-vertical fixed-left navbar-expand-md navbar-light bg-white" id="sidenav-main">
    <div class="container-fluid">
      <!-- Brand -->
      <a class="navbar-brand pt-0" href="../index.html">
        <img src="#" class="navbar-brand-img" alt="Logo">
      </a>
     
      <!-- Collapse -->
      <div class="collapse navbar-collapse" id="sidenav-collapse-main">
        <!-- Navigation -->
        <?php require_once 'sidebar.php'; ?>
      </div>
    </div>
  </nav>
  <div class="main-content">
    <!-- Navbar -->
    <?php require_once 'navbar.php'; ?>
    <!-- End Navbar -->
    <!-- Header -->
    <div class="header bg-gradient-primary pb-8 pt-5 pt-md-8">
      <div class="container-fluid">
      <div class="row">
            <?php 
            if($messages !='')
            {
              $_SESSION['message'] = '';
              $messages = json_decode($messages, true);
              if($messages['status'] == 'success')
              { ?>
                  <div class="messages success"><?php echo $messages['message'] ?></div>
        <?php }
              else
              { ?>
                  <div class="messages error"><?php echo $messages['message'] ?></div>
        <?php }
            
            } ?>
            
            <div class="mb-0">
                <a href="<?php echo BASE_ADMIN_URL.'add-pricing'; ?>" style="color:#fff">Add Vehicle Pricing</a>
            </div>
        </div>
      </div>
    </div>
    <div class="container-fluid mt--7">
      <!-- Table -->
      <div class="row">
        <div class="col">
          <div class="card shadow">
            <div class="card-header border-0">
              <h3 class="mb-0">All Vehicles Pricing</h3>
            </div>
            <div class="vehicle-selector">
              <select id="vehicleSelector">
              <?php 
                $result = getVehicles($id=null);     
                if ($result->num_rows > 0) {
                  while ($row = $result->fetch_assoc()) {
                    echo "<option value=".$row["id"].">".$row["name"]."</option>";
                  }
                }
              ?>
              </select>
            </div>
            <div class="table-responsive">
              <table class="table align-items-center table-flush">
                <thead class="thead-light">
                  <tr>
                    <th scope="col">ID</th>
                    <th scope="col">Vehicle Type</th>
                    <th scope="col">Day of Week</th>
                    <th scope="col">Min Hours Within City</th>
                    <th scope="col">Min Hours City to City</th>
                    <th scope="col">Hour Rate</th>
                    <th scope="col">Per Mile Rate</th>
                    <th scope="col">Min Charge</th>
                    <th scope="col">Action</th>
                  </tr>
                </thead>
                <tbody id="vehiclePricingList">
                  <?php 
                  $result = getVehiclesPricingList();     
                  if ($result->num_rows > 0) {
                    while ($row = $result->fetch_assoc()) {
                      echo "<tr>";
                      echo "<td>" . $row["id"] . "</td>";
                      echo "<td>" . $row["vehicle_type"] . "</td>";
                      echo "<td>" . $row["day_of_week"] . "</td>";
                      echo "<td>" . $row["min_hours_within_city"] . "</td>";
                      echo "<td>" . $row["min_hours_city_to_city"] . "</td>";
                      echo "<td>" . $row["hour_rate"] . "</td>";
                      echo "<td>" . $row["per_mile_rate"] . "</td>";
                      echo "<td>" . $row["min_charge"] . "</td>";
                      echo "<td class='text-right'>
                              <div class='dropdown'>
                                <a class='btn btn-sm btn-icon-only text-light' href='#' role='button' data-toggle='dropdown' aria-haspopup='true' aria-expanded='false'>
                                  <i class='fas fa-ellipsis-v'></i>
                                </a>
                                <div class='dropdown-menu dropdown-menu-right dropdown-menu-arrow'>
                                  <a class='dropdown-item' href='pricing-update?id=" . $row["id"] . "'>Edit</a>
                                  <a class='dropdown-item' href='delete-pricing?id=" . $row["id"] . "'>Delete</a>
                                </div>
                              </div>
                            </td>";
                      echo "</tr>";
                  }                    

                  }else {
                    echo "<tr><td colspan='10'>No records found</td></tr>";
                } ?>
                </tbody>
              </table>
            </div>
            <!-- <div class="card-footer py-4">
              <nav aria-label="...">
                <ul class="pagination justify-content-end mb-0">
                  <li class="page-item disabled">
                    <a class="page-link" href="#" tabindex="-1">
                      <i class="fas fa-angle-left"></i>
                      <span class="sr-only">Previous</span>
                    </a>
                  </li>
                  <li class="page-item active">
                    <a class="page-link" href="#">1</a>
                  </li>
                  <li class="page-item">
                    <a class="page-link" href="#">2 <span class="sr-only">(current)</span></a>
                  </li>
                  <li class="page-item"><a class="page-link" href="#">3</a></li>
                  <li class="page-item">
                    <a class="page-link" href="#">
                      <i class="fas fa-angle-right"></i>
                      <span class="sr-only">Next</span>
                    </a>
                  </li>
                </ul>
              </nav>
            </div> -->
          </div>
        </div>
      </div>
      
   
    </div>
  </div>
  <!--   Core   -->
  <?php echo require_once 'footer.php' ?>
  
</body>
<script>
    // jQuery to handle select box change event
    $(document).ready(function() {
        $('#vehicleSelector').on('change', function() {
            var vehicleId = $(this).val(); // Get the selected vehicle id
            //alert(vehicleId);
            // Make an AJAX request to fetch updated records based on the selected vehicle id
            $.ajax({
                url: '<?php echo BASE_ADMIN_URL ?>ajax.php',
                type: 'GET',
                data: { action: 'getAjaxVehiclesPricingList',vehicleId: vehicleId },
                success: function(response) {
                    $('#vehiclePricingList').html(response); // Update the table
                }
            });
        });
    });
</script>
</html>