<?php

// Include config file
require_once "../env.php";
require_once '../routes.php';
// Function to load page based on URL
function loadPage($url) {
    // Extract page name and query parameters from URL
    $urlParts = parse_url($url);
    $page = basename($urlParts['path']);
    // $queryParams = array();
    // if(isset($urlParts['query'])) {
    //     parse_str($urlParts['query'], $queryParams);
    // }

    if($page == 'admin') {
        $page = 'login';
    }

    // Define allowed pages
    $allowedPages = array("dashboard", "login", "functions", "logout", "add-vehicle", "addPricing", "vehicles", "pricing-update", "delete-pricing","add-pricing","update-vehicle","delete-vehicle");

    // Check if the requested page is allowed
    if (in_array($page, $allowedPages)) {
        // Load the requested page
        if ($page !== "delete-pricing" && $page !=='delete-vehicle') {
            require_once "$page.php"; // Assuming your pages are named as dashboard.php, items.php, etc.
        }

        // Call the appropriate function based on the page
        switch ($page) {
            case 'delete-pricing':
                if(isset($_GET['id']) && $_GET['id']!='')
                {
                    deletePricing($_GET['id']);
                } else {
                    header("HTTP/1.0 404 Not Found");
                    include("../404.php"); // Include the 404 error page
                    exit(); // Stop further execution
                }
                break;
                case 'delete-vehicle':
                if(isset($_GET['id']) && $_GET['id']!='')
                {
                    deleteVehicle($_GET['id']);
                } else {
                    header("HTTP/1.0 404 Not Found");
                    include("../404.php"); // Include the 404 error page
                    exit(); // Stop further execution
                }
                break;
            // Add more cases for other pages as needed
        }
    } else {
        // Redirect to 404 error page
        header("HTTP/1.0 404 Not Found");
        include("../404.php"); // Include the 404 error page
        exit(); // Stop further execution
    }
}



// Get the current URL
$currentUrl = $_SERVER['REQUEST_URI'];

// Load the appropriate page based on the URL
loadPage($currentUrl);
?>
