<?php
// Check if the user is already logged in, if yes, redirect them to the dashboard
if(!isset($_SESSION["loggedin"]) || $_SESSION["loggedin"] === false){
  header("Location: " . BASE_ADMIN_URL); // Assuming login.php is your login page
    exit;
}
$currentUrl = $_SERVER['REQUEST_URI'];
$urlParts = parse_url($url);
$page = basename($urlParts['path']);
if(isset($_GET['id']) && $_GET['id']!='')
{
  if($page == 'update-vehicle')
  {
    $vehicle_name = '';
    $result = getVehicles($_GET['id']);
    if ($result->num_rows > 0) {
      $recordid = $_GET['id'];
      $actualresult = $result->fetch_assoc();
      $vehicle_name = $actualresult['name'];
      
    }
  }
}
else
{
  header("HTTP/1.0 404 Not Found");
  include("../404.php"); // Include the 404 error page
  exit(); // Stop further execution
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
<meta charset="utf-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
  <title>
    Dashboard
  </title>
  <?php echo require_once 'header.php' ?>
</head>

<body class="">
  <nav class="navbar navbar-vertical fixed-left navbar-expand-md navbar-light bg-white" id="sidenav-main">
    <div class="container-fluid">
      <!-- Brand -->
      <a class="navbar-brand pt-0" href="../index.html">
        <img src="#" class="navbar-brand-img" alt="Logo">
      </a>
     
      <!-- Collapse -->
      <div class="collapse navbar-collapse" id="sidenav-collapse-main">
        <!-- Navigation -->
        <?php require_once 'sidebar.php'; ?>
      </div>
    </div>
  </nav>
  <div class="main-content">
    <!-- Navbar -->
    <nav class="navbar navbar-top navbar-expand-md navbar-dark" id="navbar-main">
      <div class="container-fluid">
       
        <!-- User -->
        <ul class="navbar-nav align-items-center d-none d-md-flex">
          <li class="nav-item dropdown">
            <a class="nav-link pr-0" href="#" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
              <div class="media align-items-center">
                <span class="avatar avatar-sm rounded-circle">
                  <img alt="Image placeholder" src="assets/img/theme/team-4-800x800.jpg">
                </span>
                <div class="media-body ml-2 d-none d-lg-block">
                  <span class="mb-0 text-sm  font-weight-bold">Admin</span>
                </div>
              </div>
            </a>
            <div class="dropdown-menu dropdown-menu-arrow dropdown-menu-right">
              <div class=" dropdown-header noti-title">
                <h6 class="text-overflow m-0">Welcome!</h6>
              </div>
              
              <div class="dropdown-divider"></div>
              <a href="<?php echo BASE_ADMIN_URL; ?>logout" class="dropdown-item">
                <i class="ni ni-user-run"></i>
                <span>Logout</span>
              </a>
            </div>
          </li>
        </ul>
      </div>
    </nav>
    <!-- End Navbar -->
    <!-- Header -->
    <div class="header bg-gradient-primary pb-8 pt-5 pt-md-8">
      <div class="container-fluid">
        <div class="row">
            <div class="mb-0">
                <h1>Update Vehicle</h1>
            </div>
        </div>
      </div>
    </div>
      <div class="container-fluid mt--7">
        <!-- Table -->
        <div class="row">
            <div class="col">
              <form action="functions" method="post">
                <input type="hidden" name="recordid" value="<?php echo $recordid; ?>">
                <div class="col-md-12">
                  <label>Vehicle Name</label>
                  <input type="text" name="vehicle" value="<?php echo $vehicle_name; ?>">
                </div>
                <div class="col-md-12">
                  <input type="submit" name="updateVehicle" value="Submit">
                </div>
              </form>
            </div>
        </div>
      </div>
      
   
    </div>
  </div>
  <!--   Core   -->
  <?php echo require_once 'footer.php' ?>
  
</body>

</html>

<script>
$(document).ready(function() {
    $('form').validate({
        rules: {
            vehicle: {
                required: true,
            }
        },
        submitHandler: function(form) {
            form.submit(); // Submit the form if validation passes
        }
    });
});
</script>
