document.addEventListener('DOMContentLoaded', function () {
	// Load Day.js plugins
	['custom'].forEach(function (format) {
		const plugin = 'dayjs_plugin_customFormat';
		if (plugin in window)
		{
			dayjs.extend(window[plugin]);
		}
	});

	jQuery('#minTime, #maxTime').timepicker();
	const $picker = jQuery('#timepicker-input').timepicker();
	const $step = jQuery('#step');
	const defaultFormat = $picker.timepicker('format');
	const defaultScheme = $picker.timepicker('scheme') || '';
	const minStep = parseInt(document.getElementById('step').min);
	const maxStep = parseInt(document.getElementById('step').max);
	const timeRegex = new RegExp('^' + document.getElementById('minTime').pattern.replace(/\?$/, '') + '$');
	let has_second = false;
	jQuery('.options-control').on('change', function () {
		if (this.type == 'text')
		{
			this.value = this.value.replace(/^\s+|\s+$/, '');
		}
		let this_value = this.value;
		switch (this.id)
		{
			case 'id':
				this_value = this_value.replace(/[^\w\-\.:]+/g, '').replace(/^[^a-z]+/i, '');
				document.getElementById('timepicker-id').textContent = (this_value.length > 0) ? ' id="' + this.value + '"' : '';
				document.getElementById('timepicker-target').textContent = (this_value.length > 0) ? ' data-target="#' + this.value + '"' : '';
				document.getElementById('id-reset-btn').disabled = !(this_value.length > 0);
				this.value = this_value;
				break;
			case 'name':
				this_value = this.value.replace(/[^\w\-\.:]+/g, '').replace(/^[^a-z]+/i, '');;
				document.getElementById('timepicker-name').textContent = (this_value.length > 0) ? ' name="' + this.value + '"' : '';
				document.getElementById('name-reset-btn').disabled = !(this_value.length > 0);
				this.value = this_value;
				break;
			case 'format':
				$picker.val('').timepicker('time', null);
				has_second = (document.getElementById('format').value.replace(/\[[^\]]*\]/g).indexOf('s') >= 0);
				if (!has_second)
				{
					let step = parseInt($step.val());
					if (step % 60 > 0)
					{
						step = Math.round(step / 60) * 60;
						$step.data('prev', step).val(step.toString());
					}
				}
				break;
			case 'maxTime':
			case 'minTime':
				if (!timeRegex.test(this_value))
				{
					this_value = '';
				}
				document.getElementById(this.id + '-reset-btn').disabled = !(this_value.length > 0);
				this.value = this_value;
				break;
			case 'step':
				this_value = this_value.replace(/\D+/g, '');
				if (this_value.length > 0)
				{
					const prev_value = $step.data('prev');
					this_value = parseInt(this_value);
					if (!has_second && this_value != prev_value)
					{
						this_value = ((this_value > prev_value) ? Math.ceil(this_value / 60) : Math.floor(this_value / 60)) * 60;
					}
					this_value = (this_value < 0 || this_value < minStep || this_value > maxStep) ? '' : this_value.toString();
				}
				document.getElementById('step-reset-btn').disabled = !(this_value.length > 0);
				this.value = this_value;
				$step.data('prev', this_value);
				break;
			case 'scheme':
				document.getElementById('scheme-reset-btn').disabled = !(this_value.length > 0);
				break;
		}
		let attribs = '', options = {};
		jQuery.each({ format: 'format', minTime: 'min', maxTime: 'max', step: 'step', scheme: 'scheme' }, function (option, attr) {
			const input = document.getElementById(option);
			const value = input.value;
			jQuery('.timepicker-input').timepicker(option, value);
			if (value.length > 0 && !(option == 'format' && value == defaultFormat) && !(option == 'scheme' && value == defaultScheme))
			{
				options[option] = value;
				attribs += ' ' + ((attr == 'format' || attr == 'scheme') ? 'data-' : '') + attr + '="' + value + '"';
			}
		});
		const paramtype = document.getElementById('paramtype').value;
		const togglebtn = (document.getElementById('togglebtn').selectedIndex > 0);
		jQuery('.timepicker-input-group').toggleClass('d-none', !togglebtn);
		$picker.toggleClass('d-none', togglebtn);
		jQuery('#timepicker-indent').toggleClass('d-none', !togglebtn);
		document.getElementById('timepicker-attribs').textContent = (paramtype == 'HTML') ? attribs : '';
		document.getElementById('timepicker-params').textContent = (paramtype == 'JS' && attribs.length > 0) ? JSON.stringify(options, null, "\t").replace(/"([^"]+)":/g, '$1:') : '';
	});
	const $format = jQuery('#format').val(defaultFormat).prop('readOnly', false);
	jQuery('#format-dropdown-menu').find('button').on('click', function () {
		$format.val(this.textContent).trigger('change');
	});
	jQuery('.reset-btn').on('click', function () {
		jQuery('#' + this.id.substring(0, this.id.length - 10)).val('').trigger('change');
		this.disabled = true;
	});
});